package GUI;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.StringTokenizer;

import javax.swing.JButton;
import javax.swing.JCheckBox;

import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.SwingWorker;

import FlashReader.AbcFile;
import FlashReader.DoABC;
import FlashReader.SWF;
import FlashReader.Tag2;
import FlashReader.Unprotector2;
import Main.Main;

import doABC.MethodBodyInfo;

public class SecureSWF extends JInternalFrame {

	public  GUIswfReader gui;
	private JButton unprotectButton;
	private JTextField methods;
	private JLabel methodsLabel;
	private SpringLayout springLayout;
	private JCheckBox statementCheckBox;
	private  JCheckBox flowCheckBox;
	private  JCheckBox dynamic;
	private JCheckBox branchCheckBox;
	private SWF swf;
	/**
	 * Create the frame
	 */
	public SecureSWF(final GUIswfReader gui,SWF swf) {
		super("Secure SWF unprotector",
		          true, //resizable
		          true, //closable
		          true, //maximizable
		          true);//iconifiable
		this.gui=gui;
		this.swf = swf;
		setTitle("Secure SWF 3.1 - unprotector beta 1");
		springLayout = new SpringLayout();
		getContentPane().setLayout(springLayout);
		setBounds(100, 100, 500, 375);
		methodsLabel = new JLabel();
		methodsLabel.setText("Methods id");
		getContentPane().add(methodsLabel);
		springLayout.putConstraint(SpringLayout.SOUTH, methodsLabel, 60, SpringLayout.NORTH, getContentPane());
		springLayout.putConstraint(SpringLayout.WEST, methodsLabel, 30, SpringLayout.WEST, getContentPane());
		methods = new JTextField();
		//methods.setText("0-"+(swf.getChoosedTag().ENmethod_body_info.size()-1));
		System.out.println("zaimp1");
		getContentPane().add(methods);
		springLayout.putConstraint(SpringLayout.SOUTH, methods, 62, SpringLayout.NORTH, getContentPane());
		springLayout.putConstraint(SpringLayout.EAST, methods, 200, SpringLayout.EAST, methodsLabel);
		springLayout.putConstraint(SpringLayout.WEST, methods, 5, SpringLayout.EAST, methodsLabel);
		unprotectButton = new JButton();
		unprotectButton.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent e) {
				/*Integer[] tmp= getToNop();
				for (int i:tmp){
					MethodBodyInfo method = MethodBodyInfo.ENmethod_body_info.get(i);
					byte b [] =method.getCode();
					byte[] result = (new Unprotect()).unprotect1(b);
					method.setCode(result);
				}*/
				
				
				 SwingWorker worker = new SwingWorker() {

					
					 protected Object doInBackground() {
						 Integer[] tmp= getToNop();
						 DoABC abDoABC;
						 AbcFile abc = ((DoABC)Main.choosedTag).getAbcData();
	
							if(statementCheckBox.isSelected()){
								for (int i:tmp){
									MethodBodyInfo method = abc.ENmethod_body_info.get(i);
									byte b [] =method.getCode();
									new Unprotector2().unprotectStatementLevelRandomization(b);
									byte[] result = Tag2.getBytes();
									
									method.setCode(result);
								}
							}
							if(flowCheckBox.isSelected()){
								for (int i:tmp){
									MethodBodyInfo method = abc.ENmethod_body_info.get(i);
									byte b [] =method.getCode();
									new Unprotector2().controlFlowObfuscation(b);
									byte[] result = Tag2.getBytes();
									
									method.setCode(result);
								}
							}
						
							if(dynamic.isSelected()){
								for (int i:tmp){
									MethodBodyInfo method = abc.ENmethod_body_info.get(i);
									byte b [] =method.getCode();
									new Unprotector2().dynamicCodeWrapping(b);
									byte[] result = Tag2.getBytes();
									
									method.setCode(result);
								}
							}
							
							if(branchCheckBox.isSelected()){
								for (int i:tmp){
									MethodBodyInfo method = abc.ENmethod_body_info.get(i);
									byte b [] =method.getCode();
									new Unprotector2().unprotectChopAndJump(b);
									byte[] result = Tag2.getBytes();
									
									method.setCode(result);
								}
							}
							
							 
						 return null;
						}
					 
					 
					 @Override
				       protected void done() {
						 gui.showInfo("Unprotected! :)");
				       }

					 
			            
			        };
			        
			        
			        
			       
			        
				worker.execute();
				
				
				/*
				for (int i:tmp){
					MethodBodyInfo method = MethodBodyInfo.ENmethod_body_info.get(i);
					byte b [] =method.getCode();
					new Unprotector2().unprotectLevelTwo(b);
					byte[] result = Tag.getBytes();
					
					method.setCode(result);
				}
				
				for (int i:tmp){
					MethodBodyInfo method = MethodBodyInfo.ENmethod_body_info.get(i);
					byte b [] =method.getCode();
					new Unprotector2().unprotectLevelThree(b);
					byte[] result = Tag.getBytes();
					
					method.setCode(result);
				}
				
				for (int i:tmp){
					MethodBodyInfo method = MethodBodyInfo.ENmethod_body_info.get(i);
					byte b [] =method.getCode();
					new Unprotector2().unprotectLevelOne(b);
					byte[] result = Tag.getBytes();
					
					method.setCode(result);
				}
				
				for (int i:tmp){
					MethodBodyInfo method = MethodBodyInfo.ENmethod_body_info.get(i);
					byte b [] =method.getCode();
					new Unprotector2().unprotectLevelFour(b);
					byte[] result = Tag.getBytes();
					
					method.setCode(result);
				}*/
				
				
			}
		});
		unprotectButton.setLabel("Unprotect");
		unprotectButton.setText("Unprotect");
		getContentPane().add(unprotectButton);
		springLayout.putConstraint(SpringLayout.SOUTH, unprotectButton, 300, SpringLayout.NORTH, getContentPane());
		springLayout.putConstraint(SpringLayout.WEST, unprotectButton, 215, SpringLayout.WEST, getContentPane());

		statementCheckBox = new JCheckBox();
		statementCheckBox.setText("Statement-level-Randomization");
		getContentPane().add(statementCheckBox);
		springLayout.putConstraint(SpringLayout.EAST, statementCheckBox, 202, SpringLayout.WEST, methodsLabel);
		springLayout.putConstraint(SpringLayout.WEST, statementCheckBox, 0, SpringLayout.WEST, methodsLabel);
		springLayout.putConstraint(SpringLayout.SOUTH, statementCheckBox, 134, SpringLayout.NORTH, getContentPane());
		springLayout.putConstraint(SpringLayout.NORTH, statementCheckBox, 110, SpringLayout.NORTH, getContentPane());

		flowCheckBox = new JCheckBox();
		flowCheckBox.setText("Control Flow Obfuscation");
		getContentPane().add(flowCheckBox);
		springLayout.putConstraint(SpringLayout.EAST, flowCheckBox, 167, SpringLayout.WEST, statementCheckBox);
		springLayout.putConstraint(SpringLayout.WEST, flowCheckBox, 0, SpringLayout.WEST, statementCheckBox);
		springLayout.putConstraint(SpringLayout.SOUTH, flowCheckBox, 175, SpringLayout.NORTH, getContentPane());
		springLayout.putConstraint(SpringLayout.NORTH, flowCheckBox, 151, SpringLayout.NORTH, getContentPane());

		dynamic = new JCheckBox();
		dynamic.setText("Dynamic Code Wrapping");
		getContentPane().add(dynamic);
		springLayout.putConstraint(SpringLayout.EAST, dynamic, 197, SpringLayout.WEST, flowCheckBox);
		springLayout.putConstraint(SpringLayout.WEST, dynamic, 0, SpringLayout.WEST, flowCheckBox);
		springLayout.putConstraint(SpringLayout.SOUTH, dynamic, 214, SpringLayout.NORTH, getContentPane());
		springLayout.putConstraint(SpringLayout.NORTH, dynamic, 190, SpringLayout.NORTH, getContentPane());

		branchCheckBox = new JCheckBox();
		branchCheckBox.setText("ChopAndJump(beta)");
		getContentPane().add(branchCheckBox);
		springLayout.putConstraint(SpringLayout.SOUTH, branchCheckBox, 134, SpringLayout.NORTH, getContentPane());
		springLayout.putConstraint(SpringLayout.WEST, branchCheckBox, 260, SpringLayout.WEST, getContentPane());
		//
	}
	
	public Integer[] getToNop(){
		Integer result[];
		ArrayList<Integer> al = new ArrayList<Integer>();
		String s = methods.getText();
		
		if (!s.contains(",")) s= s+ ",";
		
		StringTokenizer st = new StringTokenizer(s,",");
		
		
		
		
		while( st.hasMoreTokens()){
			String ss = st.nextToken();
			if (ss.contains("-")){
				StringTokenizer st2 = new StringTokenizer(ss,"-");
				
				
				int a = Integer.parseInt(st2.nextToken());
				int b =  Integer.parseInt(st2.nextToken());

				for ( int i = a; i <= b;i++){
					al.add(i);
				}
				
				
			}else{
				al.add(Integer.parseInt(ss));
			}
		}
		result = new Integer[al.size()];
		result = al.toArray(result);
		//// (al);
		return result;
	}

}
